package MusicLandscape.util.matcher;

import MusicLandscape.entities.Track;
import MusicLandscape.util.MyMatcher;

/**
 * A matcher that always matches a track. Only null values do not match.
 *
 * @author Jonas Altrock (ew20b126@technikum-wien.at)
 * @version 1
 * @since LabWork
 */
public class AlwaysMatcher extends MyMatcher<Track> {
    public AlwaysMatcher() {
        this("");
    }

    /**
     * Creates a Matcher object with a specified pattern.
     *
     * @param pat the pattern of this matcher
     */
    public AlwaysMatcher(String pat) {
        super(pat);
    }

    /**
     * Matches any valid object!<br>
     *
     * @param track the object to match
     * @return whether t matches the pattern of this matcher.
     */
    @Override
    public boolean matches(Track track) {
        return track != null;
    }

    /**
     * Sets the pattern of this matcher.
     *
     * @param pat the pattern to set
     */
    @Override
    public void setPattern(String pat) {

    }

    /**
     * Gets the pattern of this matcher.
     * <p>
     * The pattern is returned in a format that is considered valid in setPattern.
     *
     * @return the pattern
     */
    @Override
    public String getPattern() {
        return null;
    }

    /**
     * Returns a string representation of this matcher.
     *
     * @return a string representation of the object.
     */
    @Override
    public String toString() {
        return "all tracks";
    }
}
